<?php if ('layout_two' === $settings['layout_type']) : ?>
	<!--Services One Start-->
	<section class="services-one">
		<?php if (!empty($settings['layout_two_shape_one']['url'])) : ?>
			<div class="services-one-shape-1 float-bob-x">
				<img src="<?php echo esc_url($settings['layout_two_shape_one']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['layout_two_shape_one']['id'])); ?>">
			</div>
		<?php endif; ?>
		<?php if (!empty($settings['layout_two_shape_two']['url'])) : ?>
			<div class="services-one-shape-2">
				<img src="<?php echo esc_url($settings['layout_two_shape_two']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['layout_two_shape_two']['id'])); ?>">
			</div>
		<?php endif; ?>
		<div class="container">
			<div class="services-one__top">
				<div class="row">
					<?php if (!empty($settings['layout_two_sec_title']) || !empty($settings['layout_two_sec_sub_title'])) : ?>
						<div class="col-xl-7 col-lg-6">
							<div class="services-one__top-left">
								<div class="section-title text-left">
									<?php if (!empty($settings['layout_two_sec_sub_title'])) : ?>
										<div class="section-sub-title-box">
											<p class="section-sub-title"><?php echo wp_kses($settings['layout_two_sec_sub_title'], 'roofsie_allowed_tags'); ?></p>
											<?php if (!empty($settings['layout_two_sub_title_image']['url'])) : ?>
												<div class="section-title-shape-1">
													<img src="<?php echo esc_url($settings['layout_two_sub_title_image']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['layout_two_sub_title_image']['id'])); ?>">
												</div>
											<?php endif; ?>
										</div>
									<?php endif; ?>
									<?php if (!empty($settings['layout_two_sec_title'])) : ?>
										<h2 class="section-title__title"><?php echo wp_kses($settings['layout_two_sec_title'], 'roofsie_allowed_tags'); ?></h2>
									<?php endif; ?>
								</div>
							</div>
						</div>
					<?php endif; ?>
					<?php if (!empty($settings['layout_two_summary_text'])) : ?>
						<div class="col-xl-5 col-lg-6">
							<div class="services-one__top-right">
								<p class="services-one__top-right-text"><?php echo wp_kses($settings['layout_two_summary_text'], 'roofsie_allowed_tags'); ?></p>
							</div>
						</div>
					<?php endif; ?>
				</div>
			</div>
			<div class="services-one__bottom">
				<div class="row">
					<?php if (is_array($settings['layout_two_service_item'])) : ?>
						<?php $i = 1;
						foreach ($settings['layout_two_service_item'] as $item) : ?>
							<!--Services One Single Start-->
							<div class="col-xl-4 col-lg-4 wow fadeInUp" data-wow-delay="<?php echo esc_attr($i); ?>00ms">
								<div class="services-one__single">
									<?php if (!empty($item['image']['url'])) : ?>
										<div class="services-one__img">
											<img src="<?php echo esc_url($item['image']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($item['image']['id'])); ?>">
										</div>
									<?php endif; ?>
									<div class="services-one__content">
										<div class="services-one__icon icon-svg-large">
											<?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
										</div>
										<h3 class="services-one__title"><a <?php echo esc_attr(!empty($item['url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['url']['url']); ?>"><?php echo esc_html($item['title']); ?></a></h3>
										<p class="services-one__text"><?php echo esc_html($item['content']); ?></p>
										<div class="services-one__read-more">
											<a <?php echo esc_attr(!empty($item['url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['url']['url']); ?>"><?php echo esc_html($item['button_label']); ?> <i class="fa fa-arrow-right"></i></a>
										</div>
									</div>
								</div>
							</div>
							<!--Services One Single End-->
					<?php $i++;
						endforeach;
					endif; ?>
				</div>
			</div>
		</div>
	</section>
	<!--Services One End-->
<?php endif; ?>