<?php if ('layout_three' === $settings['layout_type']) : ?>
	<!--Services Two Start-->
	<section class="services-two">
		<?php if (!empty($settings['layout_three_shape']['url'])) : ?>
			<div class="services-two-shape-1 float-bob-x">
				<img src="<?php echo esc_url($settings['layout_three_shape']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['layout_three_shape']['id'])); ?>">
			</div>
		<?php endif; ?>
		<div class="container">
			<?php if (!empty($settings['layout_three_sec_title']) || !empty($settings['layout_three_sec_sub_title'])) : ?>
				<div class="section-title text-center">
					<div class="section-sub-title-box">
						<?php if (!empty($settings['layout_three_sec_sub_title'])) : ?>
							<p class="section-sub-title"><?php echo wp_kses($settings['layout_three_sec_sub_title'], 'roofsie_allowed_tags'); ?></p>
						<?php endif; ?>
						<?php if (!empty($settings['layout_three_sub_title_image']['url'])) : ?>
							<div class="section-title-shape-1">
								<img src="<?php echo esc_url($settings['layout_three_sub_title_image']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['layout_three_sub_title_image']['id'])); ?>">
							</div>
						<?php endif; ?>
					</div>
					<?php if (!empty($settings['layout_three_sec_title'])) : ?>
						<h2 class="section-title__title"><?php echo wp_kses($settings['layout_three_sec_title'], 'roofsie_allowed_tags'); ?></h2>
					<?php endif; ?>
				</div>
			<?php endif; ?>
			<div class="row">
				<?php if (is_array($settings['layout_three_service_item'])) : ?>
					<?php $i = 1;
					foreach ($settings['layout_three_service_item'] as $item) : ?>
						<!--Services Two Single Start-->
						<div class="col-xl-3 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay="<?php echo esc_attr($i); ?>00ms">
							<div class="services-two__single">
								<div class="services-two__icon icon-svg-large">
									<?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
								</div>
								<h3 class="services-two__title">
									<a <?php echo esc_attr(!empty($item['url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['url']['url']); ?>"><?php echo wp_kses($item['title'], 'roofsie_allowed_tags'); ?></a>
								</h3>
								<div class="services-two__read-more">
									<a <?php echo esc_attr(!empty($item['url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['url']['url']); ?>"> <i class="fa fa-arrow-right"></i> <?php echo esc_html($item['button_label']); ?></a>
								</div>
							</div>
						</div>
						<!--Services Two Single End-->
				<?php $i++;
					endforeach;
				endif; ?>
			</div>
		</div>
	</section>
	<!--Services Two End-->
<?php endif; ?>