<?php if ('layout_six' === $settings['layout_type']) : ?>
	<!--Services Page Start-->
	<section class="services-carousel-page">
		<div class="container">
			<div class="services-carousel thm-owl__carousel owl-theme owl-carousel carousel-dot-style" data-owl-options='<?php echo esc_attr(roofsie_get_owl_options($settings)); ?>'>
				<?php if (is_array($settings['layout_five_service_item'])) : ?>
					<?php
					foreach ($settings['layout_five_service_item'] as $item) : ?>
						<!--Services One Single Start-->
						<div class="item">
							<div class="services-one__single">
								<?php if (!empty($item['image']['url'])) : ?>
									<div class="services-one__img">
										<img src="<?php echo esc_url($item['image']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($item['image']['id'])); ?>">
									</div>
								<?php endif; ?>
								<div class="services-one__content">
									<div class="services-one__icon icon-svg">
										<?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
									</div>
									<h3 class="services-one__title"><a <?php echo esc_attr(!empty($item['url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['url']['url']); ?>"><?php echo esc_html($item['title']); ?></a></h3>
									<p class="services-one__text"><?php echo esc_html($item['content']); ?></p>
									<div class="services-one__read-more">
										<a <?php echo esc_attr(!empty($item['url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['url']['url']); ?>"><?php echo esc_html($item['button_label']); ?> <i class="fa fa-arrow-right"></i></a>
									</div>
								</div>
							</div>
						</div>
						<!--Services One Single End-->
				<?php
					endforeach;
				endif; ?>
			</div>
		</div>
	</section>
	<!--Services Page End-->

<?php endif; ?>