<?php if ('layout_one' === $settings['layout_type']) : ?>

	<!--Feature One Start-->
	<section class="feature-one">
		<div class="container">
			<div class="feature-one__inner">
				<?php if (!empty($settings['bg']['url'])) : ?>
					<div class="feature-one__dot">
						<img src="<?php echo esc_url($settings['bg']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['bg']['id'])); ?>">
					</div>
				<?php endif; ?>
				<div class="row">
					<?php if (is_array($settings['service_item'])) : ?>
						<?php $i = 1;
						foreach ($settings['service_item'] as $item) : ?>
							<!--Feature One Single Start-->
							<div class="col-xl-4 col-lg-4 wow fadeInUp" data-wow-delay="<?php echo esc_attr($i); ?>00ms">
								<div class="feature-one__single">
									<div class="feature-one__top">
										<div class="feature-one__icon icon-svg-large">
											<?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
										</div>
										<div class="feature-one__title-box">
											<h3 class="feature-one__title"><a <?php echo esc_attr(!empty($item['url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['url']['url']); ?>"><?php echo wp_kses($item['title'], 'roofsie_allowed_tags'); ?></a></h3>
										</div>
									</div>
									<div class="feature-one__single-inner">
										<p class="feature-one__text"><?php echo wp_kses($item['content'], 'roofsie_allowed_tags'); ?></p>
										<div class="feature-one__read-more">
											<a <?php echo esc_attr(!empty($item['url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['url']['url']); ?>"><?php echo esc_html($item['button_label']); ?><i class="fa fa-arrow-right"></i></a>
										</div>
									</div>
								</div>
							</div>
							<!--Feature One Single End-->
					<?php $i++;
						endforeach;
					endif; ?>
				</div>
			</div>
		</div>
	</section>
	<!--Feature One End-->

<?php endif; ?>