<?php if ('layout_four' === $settings['layout_type']) : ?>

	<!--Services Three Start-->
	<section class="services-three">
		<div class="container">
			<?php if (!empty($settings['layout_four_sec_title']) || !empty($settings['layout_four_sec_sub_title'])) : ?>
				<div class="section-title text-center">
					<?php if (!empty($settings['layout_four_sec_sub_title'])) : ?>
						<div class="section-sub-title-box">
							<p class="section-sub-title"><?php echo wp_kses($settings['layout_four_sec_sub_title'], 'roofsie_allowed_tags'); ?></p>
							<?php if (!empty($settings['layout_four_sub_title_image']['url'])) : ?>
								<div class="section-title-shape-1">
									<img src="<?php echo esc_url($settings['layout_four_sub_title_image']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['layout_four_sub_title_image']['id'])); ?>">
								</div>
							<?php endif; ?>
						</div>
					<?php endif; ?>
					<?php if (!empty($settings['layout_four_sec_title'])) : ?>
						<h2 class="section-title__title"><?php echo wp_kses($settings['layout_four_sec_title'], 'roofsie_allowed_tags'); ?></h2>
					<?php endif; ?>
				</div>
			<?php endif; ?>
			<div class="row">
				<?php if (is_array($settings['layout_four_service_item'])) : ?>
					<?php $i = 1;
					foreach ($settings['layout_four_service_item'] as $item) : ?>
						<!--Services Three Single Start-->
						<div class="col-xl-4 col-lg-4 wow fadeInUp" data-wow-delay="<?php echo esc_attr($i); ?>00ms">
							<div class="services-three__single">
								<div class="services-three__img-box">
									<div class="services-three__border"></div>
									<div class="services-three__icon icon-svg-large">
										<?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
									</div>
									<?php if (!empty($item['image']['url'])) : ?>
										<div class="services-three__img">
											<img src="<?php echo esc_url($item['image']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($item['image']['id'])); ?>">
										</div>
									<?php endif; ?>
								</div>
								<div class="services-three__content">
									<?php if (!empty($item['tagline'])) : ?>
										<p class="services-three__sub-title"><?php echo esc_html($item['tagline']); ?></p>
									<?php endif; ?>
									<?php if (!empty($item['title'])) : ?>
										<h3 class="services-three__title"><a <?php echo esc_attr(!empty($item['url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['url']['url']); ?>"><?php echo esc_html($item['title']); ?></a></h3>
									<?php endif; ?>
								</div>
							</div>
						</div>
						<!--Services Three Single End-->
				<?php $i++;
					endforeach;
				endif; ?>
			</div>
		</div>
	</section>
	<!--Services Three End-->
<?php endif; ?>