<?php if ('layout_five' === $settings['layout_type']) : ?>
	<!--Services Page Start-->
	<section class="services-page">
		<div class="container">
			<div class="row">
				<?php if (is_array($settings['layout_five_service_item'])) : ?>
					<?php $i = 1;
					foreach ($settings['layout_five_service_item'] as $item) : ?>
						<!--Services One Single Start-->
						<div class="col-xl-4 col-lg-4 col-md-6 wow fadeInUp" data-wow-delay="<?php echo esc_attr($i); ?>00ms">
							<div class="services-one__single">
								<?php if (!empty($item['image']['url'])) : ?>
									<div class="services-one__img">
										<img src="<?php echo esc_url($item['image']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($item['image']['id'])); ?>">
									</div>
								<?php endif; ?>
								<div class="services-one__content">
									<div class="services-one__icon icon-svg">
										<?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
									</div>
									<h3 class="services-one__title"><a <?php echo esc_attr(!empty($item['url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['url']['url']); ?>"><?php echo esc_html($item['title']); ?></a></h3>
									<p class="services-one__text"><?php echo esc_html($item['content']); ?></p>
									<div class="services-one__read-more">
										<a <?php echo esc_attr(!empty($item['url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['url']['url']); ?>"><?php echo esc_html($item['button_label']); ?> <i class="fa fa-arrow-right"></i></a>
									</div>
								</div>
							</div>
						</div>
						<!--Services One Single End-->
				<?php $i++;
					endforeach;
				endif; ?>
			</div>
		</div>
	</section>
	<!--Services Page End-->

<?php endif; ?>