<?php if ('layout_one' == $settings['layout_type']) : ?>

	<!--Pricing One Start-->
	<section class="pricing-one">
		<?php if (!empty($settings['bg_image']['url'])) :  ?>
			<div class="pricing-one-bg" style="background-image: url(<?php echo esc_url($settings['bg_image']['url']); ?>);"></div>
		<?php endif; ?>
		<div class="container">
			<div class="row">
				<div class="col-xl-4 col-lg-6">
					<div class="pricing-one__left">
						<?php if (!empty($settings['sec_title']) || !empty($settings['sec_sub_title'])) : ?>
							<div class="section-title text-left">
								<?php if (!empty($settings['sec_sub_title'])) : ?>
									<div class="section-sub-title-box">
										<p class="section-sub-title"><?php echo wp_kses($settings['sec_sub_title'], 'roofsie_allowed_tags'); ?></p>
										<?php if (!empty($settings['sec_sub_image']['url'])) : ?>
											<div class="section-title-shape-1">
												<img src="<?php echo esc_url($settings['sec_sub_image']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['sec_sub_image']['id'])); ?>">
											</div>
										<?php endif; ?>
									</div>
								<?php endif; ?>
								<?php if (!empty($settings['sec_title'])) : ?>
									<h2 class="section-title__title"><?php echo wp_kses($settings['sec_title'], 'roofsie_allowed_tags'); ?></h2>
								<?php endif; ?>
							</div>
						<?php endif; ?>
						<?php if (!empty($settings['summary'])) : ?>
							<p class="pricing-one__text"><?php echo wp_kses($settings['summary'], 'roofsie_allowed_tags'); ?></p>
						<?php endif; ?>
						<div class="pricing-one__contact">
							<div class="pricing-one__contact-icon icon-svg-large">
								<?php \Elementor\Icons_Manager::render_icon($settings['phone_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
							</div>
							<div class="pricing-one__contact-number-box">
								<?php if (!empty($settings['phone_text'])) : ?>
									<p><?php echo esc_html($settings['phone_text']); ?></p>
								<?php endif; ?>
								<?php if (!empty($settings['phone_number'])) : ?>
									<h3 class="pricing-one__contact-number"><a href="<?php echo esc_url($settings['phone_url']); ?>"><?php echo esc_html($settings['phone_number']); ?></a></h3>
								<?php endif; ?>
							</div>
							<?php if (!empty($settings['email_text']) || !empty($settings['email_address'])) : ?>
								<div class="pricing-one__contact-email-box">
									<p><?php echo esc_html($settings['email_text']); ?></p>
									<h3 class="pricing-one__contact-email"><a href="mailto:<?php echo esc_attr($settings['email_address']); ?>"><?php echo esc_html($settings['email_address']); ?></a></h3>
								</div>
							<?php endif; ?>
						</div>
					</div>
				</div>
				<div class="col-xl-8">
					<div class="pricing-one__right">
						<div class="row">
							<?php $i = 1;
							foreach ($settings['price'] as $item) : ?>
								<div class="col-xl-6 col-lg-6 wow fadeInUp" data-wow-delay="<?php echo esc_attr($i); ?>00ms">
									<div class="pricing-one__single">
										<div class="pricing-one__single-inner">
											<div class="pricing-one__shape-1"></div>
											<div class="pricing-one__shape-2"></div>
											<div class="pricing-one__shape-3"></div>
											<div class="pricing-one__shape-4"></div>
											<?php if (!empty($item['shape_one']['url'])) : ?>
												<div class="pricing-one__shape-5">
													<img src="<?php echo esc_url($item['shape_one']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($item['shape_one']['id'])); ?>">
												</div>
											<?php endif; ?>
											<?php if (!empty($item['shape_two']['url'])) : ?>
												<div class="pricing-one__shape-6">
													<img src="<?php echo esc_url($item['shape_two']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($item['shape_two']['id'])); ?>">
												</div>
											<?php endif; ?>
											<div class="pricing-one__single-top">
												<h3 class="pricing-one__rate"><span><?php echo esc_html($item['currency']); ?></span><?php echo esc_html($item['price']); ?></h3>
												<p class="pricing-one__rate-change"><?php echo esc_html($item['tagline']); ?></p>
												<h4 class="pricing-one__title"><?php echo esc_html($item['name']); ?></h4>
											</div>
											<ul class="list-unstyled pricing-one__list-one ml-0">
												<?php echo wp_kses($item['features'], 'roofsie_allowed_tags'); ?>
											</ul>
											<ul class="list-unstyled pricing-one__list-two ml-0">
												<?php echo wp_kses($item['disable_features'], 'roofsie_allowed_tags'); ?>
											</ul>
											<div class="pricing-one__btn-box">
												<a <?php echo esc_attr(!empty($item['button_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['button_url']['url']); ?>" class="thm-btn pricing-one__btn"> <i class="fa fa-arrow-right"></i> <?php echo esc_html($item['button_label']); ?></a>
											</div>
										</div>
									</div>
								</div>
							<?php $i++;
							endforeach; ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!--Pricing One End-->
<?php endif; ?>