<?php if ('layout_two' == $settings['layout_type']) : ?>
	<!--Project Two Start-->
	<section class="project-two">
		<div class="project-two__container">
			<?php if (!empty($settings['sec_title']) || !empty($settings['sec_sub_title'])) : ?>
				<div class="section-title text-center">
					<?php if (!empty($settings['sec_sub_title'])) : ?>
						<div class="section-sub-title-box">
							<p class="section-sub-title"><?php echo wp_kses($settings['sec_sub_title'], 'roofsie_allowed_tags'); ?></p>
							<?php if (!empty($settings['sub_title_image']['url'])) : ?>
								<div class="section-title-shape-1">
									<img src="<?php echo esc_url($settings['sub_title_image']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['sub_title_image']['id'])); ?>">
								</div>
							<?php endif; ?>
						</div>
					<?php endif; ?>
					<?php if (!empty($settings['sec_title'])) : ?>
						<h2 class="section-title__title"><?php echo wp_kses($settings['sec_title'], 'roofsie_allowed_tags'); ?></h2>
					<?php endif; ?>
				</div>
			<?php endif; ?>
			<?php if ('yes' == $settings['enable_filter']) : ?>
				<div class="row">
					<div class="col-xl-12">
						<ul class="project-filter style1 post-filter has-dynamic-filters-counter list-unstyled clearfix">
							<li data-filter=".filter-item" class="active"><span class="filter-text"><?php esc_html_e('All', 'roofsie-addon'); ?></span></li>
							<?php foreach ($settings['filter'] as $item) :  ?>
								<li data-filter=".<?php echo esc_attr($item['slug']); ?>"><span class="filter-text"> <?php echo esc_html($item['name']); ?></span></li>
							<?php endforeach; ?>
						</ul>
					</div>
				</div>
			<?php endif; ?>
			<div class="project-two__bottom">
				<div class="row filter-layout masonary-layout">
					<?php foreach ($settings['layout_two_portfolio_item'] as $item) : ?>
						<!--Project Two Single Start-->
						<div class="col-xl-4 col-lg-6 col-md-6 filter-item <?php echo esc_attr($item['slug']); ?>">
							<div class="project-two__single">
								<div class="project-two__img-box">
									<div class="project-two__img">
										<img src="<?php echo esc_url($item['image']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($item['image']['id'])); ?>">
									</div>
									<div class="project-two__content">
										<?php if (!empty($item['icon_image']['url'])) : ?>
											<div class="project-two__icon">
												<img src="<?php echo esc_url($item['icon_image']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($item['icon_image']['id'])); ?>">
											</div>
										<?php endif; ?>
										<p class="project-two__sub-title"><?php echo esc_html($item['tag_line']); ?></p>
										<h3 class="project-two__title"><a <?php echo esc_attr(!empty($item['url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['url']['url']); ?>"><?php echo esc_html($item['title']); ?></a></h3>
									</div>
									<div class="project-two__link">
										<a class="img-popup" href="<?php echo esc_url($item['image']['url']); ?>"><i class="fa fa-link"></i></a>
									</div>
								</div>
							</div>
						</div>
						<!--Project Two Single End-->
					<?php endforeach; ?>
				</div>
			</div>
		</div>
	</section>
	<!--Project Two End-->

<?php endif; ?>