<?php if ('layout_three' == $settings['layout_type']) : ?>
	<!--Project Three Start-->
	<section class="project-three">
		<div class="container">
			<?php if (!empty($settings['sec_title']) || !empty($settings['sec_sub_title'])) : ?>
				<div class="section-title text-center">
					<?php if (!empty($settings['sec_sub_title'])) : ?>
						<div class="section-sub-title-box">
							<p class="section-sub-title"><?php echo wp_kses($settings['sec_sub_title'], 'roofsie_allowed_tags'); ?></p>
							<?php if (!empty($settings['sub_title_image']['url'])) : ?>
								<div class="section-title-shape-1">
									<img src="<?php echo esc_url($settings['sub_title_image']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['sub_title_image']['id'])); ?>">
								</div>
							<?php endif; ?>
						</div>
					<?php endif; ?>
					<?php if (!empty($settings['sec_title'])) : ?>
						<h2 class="section-title__title"><?php echo wp_kses($settings['sec_title'], 'roofsie_allowed_tags'); ?></h2>
					<?php endif; ?>
				</div>
			<?php endif; ?>
			<div class="project-three__carousel owl-carousel owl-theme thm-owl__carousel" data-owl-options='<?php echo esc_attr(roofsie_get_owl_options($settings)); ?>'>
				<?php foreach ($settings['layout_three_portfolio_item'] as $item) : ?>
					<!--Project Three Single Start-->
					<div class="item">
						<div class="project-three__single">
							<div class="project-three__img">
								<img src="<?php echo esc_url($item['image']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($item['image']['id'])); ?>">
								<div class="project-three__content">
									<div class="project-three__content-left">
										<?php if (!empty($item['title'])) : ?>
											<h3 class="project-three__title"><a <?php echo esc_attr(!empty($item['url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['url']['url']); ?>"><?php echo esc_html($item['title']); ?></a></h3>
										<?php endif; ?>
										<?php if (!empty($item['tag_line'])) : ?>
											<p class="project-three__sub-title"><?php echo esc_html($item['tag_line']); ?></p>
										<?php endif; ?>
									</div>
									<div class="project-three__arrow">
										<a class="img-popup" href="<?php echo esc_url($item['image']['url']); ?>"><span class="icon-right-arrow"></span></a>
									</div>
								</div>
							</div>
						</div>
					</div>
					<!--Project Three Single End-->
				<?php endforeach; ?>
			</div>
		</div>
	</section>
	<!--Project Three End-->
<?php endif; ?>