<?php if ('layout_one' === $settings['layout_type']) :

?>
	<!--Project One Start-->
	<section class="project-one">
		<?php if (!empty($settings['sec_title']) || !empty($settings['sec_sub_title'])) : ?>
			<div class="project-one__top">
				<div class="container">
					<div class="section-title text-center">
						<?php if (!empty($settings['sec_sub_title'])) : ?>
							<div class="section-sub-title-box">
								<p class="section-sub-title"><?php echo wp_kses($settings['sec_sub_title'], 'roofsie_allowed_tags'); ?></p>
								<?php if (!empty($settings['sub_title_image']['url'])) : ?>
									<div class="section-title-shape-1">
										<img src="<?php echo esc_url($settings['sub_title_image']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['sub_title_image']['id'])); ?>">
									</div>
								<?php endif; ?>
							</div>
						<?php endif; ?>
						<?php if (!empty($settings['sec_title'])) : ?>
							<h2 class="section-title__title"><?php echo wp_kses($settings['sec_title'], 'roofsie_allowed_tags'); ?></h2>
						<?php endif; ?>
					</div>
				</div>
			</div>
		<?php endif; ?>
		<div class="project-one__bottom">
			<div class="project-one__bottom-wrapper">
				<div class="project-one__carousel owl-carousel owl-theme thm-owl__carousel" data-owl-options='<?php echo esc_attr(roofsie_get_owl_options($settings)); ?>'>
					<?php if (is_array($settings['portfolio_item'])) : ?>
						<?php foreach ($settings['portfolio_item'] as $item) : ?>
							<!--Project One Single Start-->
							<div class="item">
								<div class="project-one__single">
									<div class="project-one__img-box">
										<div class="project-one__img">
											<img src="<?php echo esc_url($item['image']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($item['image']['id'])); ?>">
										</div>
										<div class="project-one__content">
											<h4 class="project-one__title"><a <?php echo esc_attr(!empty($item['url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['url']['url']); ?>"><?php echo wp_kses($item['title'], 'roofsie_allowed_tags'); ?></a>
											</h4>
										</div>
										<div class="project-one__link">
											<a class="img-popup" href="<?php echo esc_url($item['image']['url']); ?>"><i class="fa fa-link"></i></a>
										</div>
									</div>
								</div>
							</div>
							<!--Project One Single End-->
						<?php endforeach; ?>
					<?php endif; ?>
				</div>
			</div>
		</div>
	</section>
	<!--Project One  End-->

<?php endif; ?>