<?php if ('layout_four' == $settings['layout_type']) : ?>
	<!--Work Page Start-->
	<section class="work-page">
		<div class="container">
			<?php if ('yes' == $settings['layout_four_enable_filter']) : ?>
				<div class="work-page__top">
					<div class="row">
						<div class="col-xl-12">
							<ul class="project-filter style1 post-filter has-dynamic-filters-counter list-unstyled clearfix">
								<li data-filter=".filter-item" class="active"><span class="filter-text"><?php esc_html_e('All', 'roofsie-addon'); ?></span></li>
								<?php foreach ($settings['layout_four_filter'] as $item) :  ?>
									<li data-filter=".<?php echo esc_attr($item['slug']); ?>"><span class="filter-text"> <?php echo esc_html($item['name']); ?></span></li>
								<?php endforeach; ?>
							</ul>
						</div>
					</div>
				</div>
			<?php endif; ?>
			<div class="work-page__bottom">
				<div class="row filter-layout masonary-layout">
					<?php foreach ($settings['layout_four_portfolio_item'] as $item) : ?>
						<!--Project One Single Start-->
						<div class="col-xl-4 col-lg-6 col-md-6 filter-item <?php echo esc_attr($item['slug']); ?>">
							<div class="project-one__single">
								<div class="project-one__img-box">
									<div class="project-one__img">
										<img src="<?php echo esc_url($item['image']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($item['image']['id'])); ?>">
									</div>
									<div class="project-one__content">
										<h4 class="project-one__title">
											<a <?php echo esc_attr(!empty($item['url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['url']['url']); ?>">
												<?php echo wp_kses($item['title'], 'roofsie_allowed_tags'); ?>
											</a>
										</h4>
									</div>
									<div class="project-one__link">
										<a class="img-popup" href="<?php echo esc_url($item['image']['url']); ?>"><i class="fa fa-link"></i></a>
									</div>
								</div>
							</div>
						</div>
						<!--Project One Single End-->
					<?php endforeach; ?>
				</div>
			</div>
		</div>
	</section>
	<!--Work Page End-->
<?php endif; ?>