<?php if ('layout_five' == $settings['layout_type']) : ?>
	<!--Work Page Start-->
	<section class="work-carousel-page">
		<div class="container">
			<div class="work-carousel thm-owl__carousel owl-theme owl-carousel carousel-dot-style" data-owl-options='<?php echo esc_attr(roofsie_get_owl_options($settings)); ?>'>
				<?php foreach ($settings['layout_five_portfolio_item'] as $item) : ?>
					<!--Project One Single Start-->
					<div class="item">
						<div class="project-one__single">
							<div class="project-one__img-box">
								<div class="project-one__img">
									<img src="<?php echo esc_url($item['image']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($item['image']['id'])); ?>">
								</div>
								<div class="project-one__content">
									<h4 class="project-one__title">
										<a <?php echo esc_attr(!empty($item['url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['url']['url']); ?>">
											<?php echo wp_kses($item['title'], 'roofsie_allowed_tags'); ?>
										</a>
									</h4>
								</div>
								<div class="project-one__link">
									<a class="img-popup" href="<?php echo esc_url($item['image']['url']); ?>"><i class="fa fa-link"></i></a>
								</div>
							</div>
						</div>
					</div>
					<!--Project One Single End-->
				<?php endforeach; ?>
			</div>
		</div>
	</section>
	<!--Work Page End-->

<?php endif; ?>