<?php if ('layout_one' == $settings['layout_type']) : ?>
    <!--Newsletter Start-->
    <section class="newsletter">
        <?php if (!empty($settings['bg_image']['url'])) : ?>
            <div class="newsletter-bg" style="background-image: url(<?php echo esc_url($settings['bg_image']['url']); ?>);"> </div>
        <?php endif; ?>
        <div class="newsletter-shape-1"></div>
        <div class="newsletter-shape-2"></div>
        <div class="newsletter-shape-3"></div>
        <div class="newsletter-shape-4"></div>
        <div class="newsletter-shape-5"></div>
        <?php if (!empty($settings['bg_shape']['url'])) : ?>
            <div class="newsletter-shape-6">
                <img src="<?php echo esc_url($settings['bg_shape']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['bg_shape']['id'])); ?>">
            </div>
        <?php endif; ?>
        <?php if (!empty($settings['image']['url'])) : ?>
            <div class="newsletter-img">
                <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['image']['id'])); ?>">
            </div>
        <?php endif; ?>
        <div class="container">
            <div class="row">
                <div class="col-xl-6 col-lg-8">
                    <div class="newsletter__inner">
                        <?php if (!empty($settings['sec_title']) || !empty($settings['sec_sub_title'])) : ?>
                            <div class="section-title text-left">
                                <?php if (!empty($settings['sec_sub_title'])) : ?>
                                    <div class="section-sub-title-box">
                                        <p class="section-sub-title"><?php echo wp_kses($settings['sec_sub_title'], 'roofsie_allowed_tags'); ?></p>
                                        <?php if (!empty($settings['sub_title_image']['url'])) : ?>
                                            <div class="section-title-shape-1">
                                                <img src="<?php echo esc_url($settings['sub_title_image']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['sub_title_image']['id'])); ?>">
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                <?php endif; ?>
                                <?php if (!empty($settings['sec_title'])) : ?>
                                    <h2 class="section-title__title"><?php echo wp_kses($settings['sec_title'], 'roofsie_allowed_tags'); ?></h2>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                        <form class="newsletter__form mc-form" data-url="<?php echo esc_url($settings['url']); ?>">
                            <div class="newsletter__input-box">
                                <input type="email" placeholder="<?php echo esc_attr($settings['placeholder_text']); ?>">
                                <button type="submit" class="newsletter-btn"><i class="far fa-paper-plane"></i></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--Newsletter End-->
<?php endif; ?>