<?php $search_status = $settings['search_status']; ?>
<?php $one_page_class = 'yes' == $settings['one_page_status'] ? 'one-page-scroll-menu' : ' '; ?>
<?php if ('layout_one' === $settings['layout_type']) : ?>

	<header class="main-header clearfix">
		<div class="main-header__logo">
			<div class="main-header__logo__shape-1"></div><!-- /.main-header__logo__shape-1 -->
			<div class="main-header__logo__shape-2"></div><!-- /.main-header__logo__shape-2 -->
			<a href="<?php echo esc_url(home_url('/')); ?>">
				<img width="<?php echo esc_attr($settings['logo_dimension']['width']); ?>" height="<?php echo esc_attr($settings['logo_dimension']['height']); ?>" src="<?php echo esc_attr($settings['light_logo']['url']); ?>" id="thm-logo" alt="<?php echo esc_attr(get_bloginfo('name')); ?>">
			</a>
		</div>
		<div class="main-header__top">
			<div class="main-header__top-inner">
				<div class="main-header__top-address">
					<?php if (is_array($settings['topbar_info'])) : ?>
						<ul class="list-unstyled main-header__top-address-list ml-0">
							<?php foreach ($settings['topbar_info'] as $item) : ?>
								<li>
									<i class="icon icon-svg">
										<?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
									</i>
									<div class="text">
										<p><?php echo wp_kses($item['text'], 'roofsie_allowed_tags'); ?></p>
									</div>
								</li>
							<?php endforeach; ?>
						</ul>
					<?php endif; ?>
				</div>
				<div class="main-header__top-right">
					<?php if (is_array($settings['topbar_menu'])) : ?>
						<div class="main-header__top-menu-box">
							<ul class="list-unstyled main-header__top-menu">
								<?php foreach ($settings['topbar_menu'] as $item) : ?>
									<li><a <?php echo esc_attr(!empty($item['url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['url']['url']); ?>"><?php echo esc_html($item['menu']); ?></a></li>
								<?php endforeach; ?>
							</ul>
						</div>
					<?php endif; ?>
					<?php if (is_array($settings['social_icons'])) : ?>
						<div class="main-header__top-social-box">
							<div class="main-header__top-social">
								<?php foreach ($settings['social_icons'] as $item) : ?>
									<a class="icon-svg" href="<?php echo esc_url($item['social_url']['url']);  ?>" <?php echo esc_attr(!empty($item['social_url']['is_external']) ? 'target=_blank' : ' '); ?>>
										<?php \Elementor\Icons_Manager::render_icon($item['social_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'i'); ?>
									</a>
								<?php endforeach; ?>
							</div>
						</div>
					<?php endif; ?>
				</div>
			</div>
		</div>
		<nav class="main-menu clearfix">
			<div class="main-menu__wrapper clearfix">
				<div class="main-menu__wrapper-inner clearfix">
					<div class="main-menu__left">
						<div class="main-menu__main-menu-box">
							<a href="#" class="mobile-nav__toggler"><i class="fa fa-bars"></i></a>
							<?php
							wp_nav_menu(
								array(
									'menu' => $settings['nav_menu'],
									'menu_class' => 'main-menu__list ' . $one_page_class,
									'walker'         => class_exists('\Layerdrops\Roofsie\Megamenu\Walker_Nav_Menu') ? new \Layerdrops\Roofsie\Megamenu\Walker_Nav_Menu : '',
								)
							);
							?>
						</div>
					</div>
					<div class="main-menu__right">
						<?php if (!empty($settings['call_text'] || !empty($settings['call_number']))) : ?>
							<div class="main-menu__call">

								<div class="main-menu__call-icon">
									<?php \Elementor\Icons_Manager::render_icon($settings['call_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
								</div>

								<div class="main-menu__call-content">
									<p><?php echo esc_html($settings['call_text']); ?></p>
									<a href="<?php echo esc_url($settings['call_url']); ?>"><?php echo esc_html($settings['call_number']); ?></a>
								</div>

							</div>
						<?php endif; ?>
						<?php if (('yes' == $search_status)) : ?>
							<div class="main-menu__search-box">
								<a href="#" class="main-menu__search search-toggler icon-magnifying-glass"></a>
							</div>
						<?php endif; ?>
						<?php if (!empty($settings['button_label'])) : ?>
							<div class="main-menu__btn-box">
								<a href="<?php echo esc_url($settings['button_url']['url']); ?>" <?php echo esc_attr(!empty($settings['button_url']['is_external']) ? 'target=_blank' : ' '); ?> class="thm-btn main-menu__btn"> <i class="fa fa-arrow-right"></i><?php echo esc_html($settings['button_label']); ?></a>
							</div>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</nav>
	</header>

	<?php if (get_theme_mod('header_sticky_menu') == 'yes' && !is_admin_bar_showing()) : ?>
		<div class="stricky-header stricked-menu main-menu">
			<div class="sticky-header__content"></div><!-- /.sticky-header__content -->
		</div><!-- /.stricky-header -->
	<?php endif; ?>

<?php endif; ?>


<?php if ('layout_two' === $settings['layout_type']) : ?>

	<header class="main-header-two clearfix">
		<div class="main-header-two__top">
			<div class="container">
				<div class="main-header-two__top-inner">
					<?php if (!empty($settings['top_bar_text'])) : ?>
						<div class="main-header-two__top-left">
							<p class="main-header-two__top-left-text"><?php echo esc_html($settings['top_bar_text']); ?></p>
						</div>
					<?php endif; ?>
					<?php if (is_array($settings['social_icons'])) : ?>
						<div class="main-header-two__top-right">
							<div class="main-header-two__top-social">
								<?php foreach ($settings['social_icons'] as $item) : ?>
									<a class="icon-svg" href="<?php echo esc_url($item['social_url']['url']);  ?>" <?php echo esc_attr(!empty($item['social_url']['is_external']) ? 'target=_blank' : ' '); ?>>
										<?php \Elementor\Icons_Manager::render_icon($item['social_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'i'); ?>
									</a>
								<?php endforeach; ?>
							</div>
						</div>
					<?php endif; ?>
				</div>
			</div>
		</div>
		<div class="main-header-two__middle">
			<div class="container">
				<div class="main-header-two__middle-inner clearfix">
					<div class="main-header-two__shape-1"></div>
					<div class="main-header-two__shape-2"></div>
					<div class="main-header-two__shape-3"></div>
					<div class="main-header-two__shape-4"></div>
					<div class="main-header-two__shape-5"></div>
					<div class="main-header-two__shape-6"></div>
					<div class="main-header-two__shape-7"></div>
					<div class="main-header-two__logo">
						<a href="<?php echo esc_url(home_url('/')); ?>">
							<img width="<?php echo esc_attr($settings['logo_dimension']['width']); ?>" height="<?php echo esc_attr($settings['logo_dimension']['height']); ?>" src="<?php echo esc_attr($settings['light_logo']['url']); ?>" id="thm-logo" alt="<?php echo esc_attr(get_bloginfo('name')); ?>">
						</a>
					</div>
					<div class="main-header-two__address">
						<?php if (is_array($settings['layout_two_contact_info'])) : ?>
							<ul class="list-unstyled main-header-two__address-list ml-0">
								<?php foreach ($settings['layout_two_contact_info'] as $item) : ?>
									<li>
										<div class="icon icon-svg">
											<?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
										</div>
										<div class="content">
											<p><?php echo wp_kses($item['title'], 'roofsie_allowed_tags'); ?></p>
											<h5><?php echo wp_kses($item['content'], 'roofsie_allowed_tags'); ?></h5>
										</div>
									</li>
								<?php endforeach; ?>
							</ul>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
		<nav class="main-menu main-menu-two clearfix">
			<div class="main-menu-two__wrapper clearfix">
				<div class="container">
					<div class="main-menu-two__wrapper-inner clearfix">
						<div class="main-menu-two__wrapper-inner-bg"></div>
						<div class="main-menu-two__left">
							<div class="main-menu-two__main-menu-box">
								<a href="#" class="mobile-nav__toggler"><i class="fa fa-bars"></i></a>
								<?php
								wp_nav_menu(
									array(
										'menu' => $settings['nav_menu'],
										'menu_class' => 'main-menu__list ' . $one_page_class,
										'walker'         => class_exists('\Layerdrops\Roofsie\Megamenu\Walker_Nav_Menu') ? new \Layerdrops\Roofsie\Megamenu\Walker_Nav_Menu : '',
									)
								);
								?>
							</div>
						</div>
						<div class="main-menu-two__right">
							<?php if (('yes' == $search_status)) : ?>
								<div class="main-menu-two__search-box">
									<a href="#" class="main-menu-two__search search-toggler icon-magnifying-glass"></a>
								</div>
							<?php endif; ?>
							<?php if (!empty($settings['button_label'])) : ?>
								<div class="main-menu-two__btn-box">
									<a href="<?php echo esc_url($settings['button_url']['url']); ?>" <?php echo esc_attr(!empty($settings['button_url']['is_external']) ? 'target=_blank' : ' '); ?> class="thm-btn main-menu-two__btn"> <i class="fa fa-arrow-right"></i> <?php echo esc_html($settings['button_label']); ?></a>
								</div>
							<?php endif; ?>
						</div>
					</div>
				</div>
			</div>
		</nav>
	</header>
	<?php if (get_theme_mod('header_sticky_menu') == 'yes' && !is_admin_bar_showing()) : ?>
		<div class="stricky-header stricked-menu main-menu main-menu-two">
			<div class="sticky-header__content"></div><!-- /.sticky-header__content -->
		</div><!-- /.stricky-header -->
	<?php endif; ?>
<?php endif; ?>


<?php if ('layout_three' === $settings['layout_type']) : ?>
	<header class="main-header-three clearfix">
		<?php if (!empty($settings['layout_three_bg_image']['url'])) : ?>
			<div class="main-header-three-shape" style="background-image: url(<?php echo esc_url($settings['layout_three_bg_image']['url']); ?>)"></div>
		<?php endif; ?>
		<div class="main-header-three__top">
			<div class="container">
				<div class="main-header-three__top-inner">
					<div class="main-header-three__top-left">
						<?php if (!empty($settings['top_bar_text'])) : ?>
							<p class="main-header-three__top-left-text"><?php echo esc_html($settings['top_bar_text']); ?></p>
						<?php endif; ?>
					</div>
					<?php if (is_array($settings['topbar_menu'])) : ?>
						<div class="main-header-three__top-right">
							<ul class="list-unstyled main-header-three__top-menu">
								<?php foreach ($settings['topbar_menu'] as $item) : ?>
									<li><a <?php echo esc_attr(!empty($settings['button_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($settings['button_url']['url']); ?>"><?php echo esc_html($item['menu']); ?></a></li>
								<?php endforeach; ?>
							</ul>
						</div>
					<?php endif; ?>
				</div>
			</div>
		</div>
		<nav class="main-menu main-menu-three clearfix">
			<div class="main-menu-three__wrapper clearfix">
				<div class="container">
					<div class="main-menu-three__wrapper-inner clearfix">
						<div class="main-menu-three__logo">
							<a href="<?php echo esc_url(home_url('/')); ?>">
								<img width="<?php echo esc_attr($settings['logo_dimension']['width']); ?>" height="<?php echo esc_attr($settings['logo_dimension']['height']); ?>" src="<?php echo esc_attr($settings['light_logo']['url']); ?>" id="thm-logo" alt="<?php echo esc_attr(get_bloginfo('name')); ?>">
							</a>
						</div>
						<div class="main-menu-three__left">
							<div class="main-menu-three__main-menu-box">
								<a href="#" class="mobile-nav__toggler"><i class="fa fa-bars"></i></a>
								<?php
								wp_nav_menu(
									array(
										'menu' => $settings['nav_menu'],
										'menu_class' => 'main-menu__list ' . $one_page_class,
										'walker'         => class_exists('\Layerdrops\Roofsie\Megamenu\Walker_Nav_Menu') ? new \Layerdrops\Roofsie\Megamenu\Walker_Nav_Menu : '',
									)
								);
								?>
							</div>
						</div>
						<div class="main-menu-three__right">
							<?php if (('yes' == $search_status)) : ?>
								<div class="main-menu-three__search-box">
									<a href="#" class="main-menu-three__search search-toggler icon-magnifying-glass"></a>
								</div>
							<?php endif; ?>
							<?php if (!empty($settings['button_label'])) : ?>
								<div class="main-menu-three__btn-box">
									<a href="<?php echo esc_url($settings['button_url']['url']); ?>" <?php echo esc_attr(!empty($settings['button_url']['is_external']) ? 'target=_blank' : ' '); ?> class="thm-btn main-menu-three__btn"> <i class="fa fa-arrow-right"></i>
										<?php echo esc_html($settings['button_label']); ?>
									</a>
								</div>
							<?php endif; ?>
						</div>
					</div>
				</div>
			</div>
		</nav>
		<div class="main-menu-three__bottom">
			<div class="container">
				<div class="main-menu-three__bottom-inner">
					<?php if (is_array($settings['layout_two_contact_info'])) : ?>
						<div class="main-menu-three__bottom-left">
							<ul class="list-unstyled main-header-three__address-list ml-0">
								<?php foreach ($settings['layout_two_contact_info'] as $item) : ?>
									<li>
										<div class="icon icon-svg">
											<?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
										</div>
										<div class="content">
											<p><?php echo wp_kses($item['title'], 'roofsie_allowed_tags'); ?></p>
											<h5><?php echo wp_kses($item['content'], 'roofsie_allowed_tags'); ?></h5>
										</div>
									</li>
								<?php endforeach; ?>
							</ul>
						</div>
					<?php endif; ?>
					<?php if (is_array($settings['social_icons'])) : ?>
						<div class="main-menu-three__bottom-right">
							<div class="main-menu-three__social">
								<?php foreach ($settings['social_icons'] as $item) : ?>
									<a class="icon-svg" href="<?php echo esc_url($item['social_url']['url']);  ?>" <?php echo esc_attr(!empty($item['social_url']['is_external']) ? 'target=_blank' : ' '); ?>>
										<?php \Elementor\Icons_Manager::render_icon($item['social_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'i'); ?>
									</a>
								<?php endforeach; ?>
							</div>
						</div>
					<?php endif; ?>
				</div>
			</div>
		</div>
	</header>

	<?php if (get_theme_mod('header_sticky_menu') == 'yes' && !is_admin_bar_showing()) : ?>
		<div class="stricky-header stricked-menu main-menu main-menu-three">
			<div class="sticky-header__content"></div><!-- /.sticky-header__content -->
		</div><!-- /.stricky-header -->
	<?php endif; ?>
<?php endif; ?>


<div class="mobile-nav__wrapper">
	<div class="mobile-nav__overlay mobile-nav__toggler"></div>
	<!-- /.mobile-nav__overlay -->
	<div class="mobile-nav__content">
		<span class="mobile-nav__close mobile-nav__toggler"></span>

		<div class="logo-box">
			<a href="<?php echo esc_url(home_url('/')); ?>">
				<img width="<?php echo esc_attr($settings['logo_dimension']['width']); ?>" height="<?php echo esc_attr($settings['logo_dimension']['height']); ?>" src="<?php echo esc_attr($settings['mobile_menu_logo']['url']); ?>" id="mobile-thm-logo" alt="<?php echo esc_attr(get_bloginfo('name')); ?>">
			</a>
		</div>
		<!-- /.logo-box -->
		<div class="mobile-nav__container"></div>
		<!-- /.mobile-nav__container -->
		<?php if (!empty($settings['mobile_menu_email']) && !empty($settings['mobile_menu_phone'])) : ?>
			<ul class="mobile-nav__contact list-unstyled ml-0">
				<?php if (!empty($settings['mobile_menu_email'])) : ?>
					<li>
						<i class="fa fa-envelope"></i>
						<a href="<?php echo esc_attr($settings['mobile_menu_email']); ?>"><?php echo esc_html($settings['mobile_menu_email']); ?></a>
					</li>
				<?php endif; ?>
				<?php if (!empty($settings['mobile_menu_phone'])) : ?>
					<li>
						<i class="fa fa-phone-alt"></i>
						<a href="tel:<?php echo esc_attr(str_replace(' ', '-', $settings['mobile_menu_phone'])); ?>"><?php echo esc_html($settings['mobile_menu_phone']); ?></a>
					</li>
				<?php endif; ?>
			<?php endif; ?>
			</ul><!-- /.mobile-nav__contact -->
			<div class="mobile-nav__top">
				<div class="mobile-nav__social">
					<?php foreach ($settings['mobile_menu_social_icons'] as $social_icon) : ?>
						<a <?php echo esc_attr(!empty($social_icon['social_url']['is_external']) ? 'target=_blank' : ' '); ?> class="icon-svg" href="<?php echo esc_url($social_icon['social_url']['url']); ?>">
							<?php \Elementor\Icons_Manager::render_icon($social_icon['social_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
						</a>
					<?php endforeach; ?>
				</div><!-- /.mobile-nav__social -->
			</div><!-- /.mobile-nav__top -->
	</div>
	<!-- /.mobile-nav__content -->
</div>


<?php if ('yes' == $search_status) : ?>

	<div class="search-popup">
		<div class="search-popup__overlay search-toggler"></div>
		<!-- /.search-popup__overlay -->
		<div class="search-popup__content">
			<form action="<?php echo esc_url(home_url('/')); ?>">
				<label for="search" class="sr-only"><?php echo esc_html__('search here', 'roofsie-addon'); ?></label><!-- /.sr-only -->
				<input type="text" id="search" name="s" placeholder="<?php echo esc_attr_e('Search Here...', 'roofsie-addon'); ?>" />
				<button type="submit" aria-label="search submit" class="thm-btn">
					<i class="icon-magnifying-glass"></i>
				</button>
			</form>
		</div>
		<!-- /.search-popup__content -->
	</div>


<?php endif; ?>


<?php $roofsie_back_to_top_status = get_theme_mod('scroll_to_top', false); ?>
<?php if ('yes' === $roofsie_back_to_top_status) : ?>
	<a href="#" data-target="html" class="scroll-to-target scroll-to-top"><i class="fa <?php echo esc_attr(get_theme_mod('scroll_to_top_icon', 'fa-angle-up')); ?>"></i></a>

<?php endif; ?>