<?php if ('layout_one' == $settings['layout_type']) : ?>
	<!--Counter One Start-->
	<section class="counter-one">
		<div class="container">
			<div class="counter-one__inner">
				<?php if (!empty($settings['sec_title']) || !empty($settings['sec_sub_title'])) : ?>
					<div class="counter-one__left">
						<div class="counter-one__left-content">
							<?php if (!empty($settings['sec_sub_title'])) : ?>
								<p class="counter-one__sub-title"><?php echo wp_kses($settings['sec_sub_title'], 'roofsie_allowed_tags'); ?></p>
							<?php endif; ?>
							<?php if (!empty($settings['sec_title'])) : ?>
								<h3 class="counter-one__title"><?php echo wp_kses($settings['sec_title'], 'roofsie_allowed_tags'); ?></h3>
							<?php endif; ?>
							<?php if (!empty($settings['sub_title_image']['url'])) : ?>
								<div class="counter-one__left-icon">
									<img src="<?php echo esc_url($settings['sub_title_image']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['sub_title_image']['id'])); ?>">
								</div>
							<?php endif; ?>
						</div>
					</div>
				<?php endif; ?>
				<?php if (is_array($settings['funfact_boxes'])) : ?>
					<div class="counter-one__right">
						<ul class="list-unstyled counter-one__list ml-0">
							<?php foreach ($settings['funfact_boxes'] as $box) : ?>
								<li>
									<div class="counter-one__count-box">
										<h3 class="odometer" data-count="<?php echo esc_attr($box['counter']); ?>">00</h3>
										<span class="counter-one__plus"><?php echo esc_html($box['sign']); ?></span>
									</div>
									<p class="counter-one__text"><?php echo wp_kses($box['text'], 'roofsie_allowed_tags'); ?></p>
									<div class="counter-one__icon">
										<?php \Elementor\Icons_Manager::render_icon($box['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
									</div>
									<div class="counter-one__big-icon">
										<?php \Elementor\Icons_Manager::render_icon($box['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
									</div>
								</li>
							<?php endforeach; ?>
						</ul>
					</div>
				<?php endif; ?>
			</div>
		</div>
	</section>
	<!--Counter One End-->
<?php endif; ?>