<?php if ('layout_three' == $settings['layout_type']) : ?>
    <!--Contact Page Start-->
    <section class="contact-page">
        <?php if (!empty($settings['bg_image']['url'])) : ?>
            <div class="contact-page-shape-1">
                <img src="<?php echo esc_url($settings['bg_image']['url']) ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['layout_two_sub_title_image']['id'])); ?>">
            </div>
        <?php endif; ?>
        <div class="container">
            <?php if (!empty($settings['layout_one_title']) || !empty($settings['layout_one_sub_title'])) : ?>
                <div class="section-title text-center">
                    <?php if (!empty($settings['layout_one_sub_title'])) : ?>
                        <div class="section-sub-title-box">
                            <p class="section-sub-title"><?php echo wp_kses($settings['layout_one_sub_title'], 'roofsie_allowed_tags'); ?></p>
                            <?php if (!empty($settings['layout_two_sub_title_image']['url'])) : ?>
                                <div class="section-title-shape-1">
                                    <img src="<?php echo esc_url($settings['layout_two_sub_title_image']['url']) ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['layout_two_sub_title_image']['id'])); ?>">
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                    <?php if (!empty($settings['layout_one_title'])) : ?>
                        <h2 class="section-title__title"><?php echo wp_kses($settings['layout_one_title'], 'roofsie_allowed_tags'); ?></h2>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
            <div class="row">
                <div class="col-xl-12">
                    <div class="contact-page__form">
                        <?php if (!empty($settings['select_wpcf7_form'])) : ?>
                            <?php echo do_shortcode('[contact-form-7 id="' . $settings['select_wpcf7_form'] . '" ]'); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--Contact Page End-->
<?php endif; ?>