<?php if ('layout_one' == $settings['layout_type']) : ?>
    <!--Appointment Start-->
    <section class="appointment">
        <div class="container">
            <div class="row">
                <?php if (!empty($settings['layout_one_title']) || !empty($settings['layout_one_sub_title'])) : ?>
                    <div class="col-xl-3 col-lg-4">
                        <div class="appointment__left">
                            <?php if (!empty($settings['bg_image']['url'])) : ?>
                                <div class="appointment-shape-1" style="background-image: url(<?php echo esc_url($settings['bg_image']['url']); ?>);"></div>
                            <?php endif; ?>
                            <div class="appointment__left-content">
                                <?php if (!empty($settings['layout_one_title'])) : ?>
                                    <h3 class="appointment__title"><?php echo wp_kses($settings['layout_one_title'], 'roofsie_allowed_tags'); ?></h3>
                                <?php endif; ?>
                                <?php if (!empty($settings['layout_one_sub_title'])) : ?>
                                    <p class="appointment__text"><?php echo wp_kses($settings['layout_one_sub_title'], 'roofsie_allowed_tags'); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="col-xl-9 col-lg-8">
                    <div class="appointment__right">
                        <?php if (!empty($settings['select_wpcf7_form'])) : ?>
                            <?php echo do_shortcode('[contact-form-7 id="' . $settings['select_wpcf7_form'] . '" ]'); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--Appointment End-->
<?php endif; ?>