<?php if ('layout_one' == $settings['layout_type']) : ?>

    <!--CTA One Start-->
    <section class="cta-one">
        <div class="cta-one__img-box">
            <?php if (!empty($settings['background_image']['url'])) : ?>
                <div class="cta-one__img">
                    <img src="<?php echo esc_url($settings['background_image']['url']);  ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['background_image']['id'])); ?>">
                </div>
            <?php endif; ?>
        </div>
        <div class=" container">
            <div class="cta-one__inner">
                <div class="cta-one__left">
                    <?php if (!empty($settings['sub_title'])) : ?>
                        <p class="cta-one__sub-title"><?php echo wp_kses($settings['sub_title'], 'roofsie_allowed_tags'); ?></p>
                    <?php endif; ?>
                    <?php if (!empty($settings['title'])) : ?>
                        <h3 class="cta-one__title"><?php echo wp_kses($settings['title'], 'roofsie_allowed_tags'); ?></h3>
                    <?php endif; ?>
                </div>
                <?php if (!empty($settings['button_label'])) : ?>
                    <div class="cta-one__btn-box">
                        <a <?php echo esc_attr(!empty($settings['button_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($settings['button_url']['url']); ?>" class="thm-btn cta-one__btn">
                            <?php \Elementor\Icons_Manager::render_icon($settings['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'i'); ?>
                            <?php echo esc_html($settings['button_label']); ?>
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>
    <!--CTA One End-->

<?php endif; ?>