<?php if ('layout_two' == $settings['layout_type']) : ?>

	<!--Blog Two Start-->
	<section class="blog-two">
		<div class="container">
			<?php if (!empty($settings['sec_sub_title']) || !empty($settings['sec_title'])) : ?>
				<div class="section-title text-center">
					<?php if (!empty($settings['sec_sub_title'])) : ?>
						<div class="section-sub-title-box">
							<p class="section-sub-title"><?php echo wp_kses($settings['sec_sub_title'], 'roofsie_allowed_tags'); ?></p>
							<?php if (!empty($settings['sub_title_image']['url'])) : ?>
								<div class="section-title-shape-1">
									<img src="<?php echo esc_url($settings['sub_title_image']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['sub_title_image']['id'])); ?>">
								</div>
							<?php endif; ?>
						</div>
					<?php endif; ?>
					<?php if (!empty($settings['sec_title'])) : ?>
						<h2 class="section-title__title"><?php echo wp_kses($settings['sec_title'], 'roofsie_allowed_tags'); ?></h2>
					<?php endif; ?>
				</div>
			<?php endif; ?>
			<div class="row">
				<?php
				$blog_post_one_query_paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
				if (!empty($settings['select_category'])) :
					$blog_post_one_query_args = array(
						'post_type' => 'post',
						'post_status' => 'publish',
						'ignore_sticky_posts' => true,
						'orderby' => 'date',
						'order'   => $settings['query_order'],
						'posts_per_page' => $settings['post_count']['size'],
						'paged'          => $blog_post_one_query_paged,
						'tax_query' => array(
							array(
								'taxonomy' => 'category',
								'field' => 'slug',
								'terms' => $settings['select_category']
							)
						)
					);
				else :

					$blog_post_one_query_args = array(
						'post_type' => 'post',
						'post_status' => 'publish',
						'ignore_sticky_posts' => true,
						'orderby' => 'date',
						'paged'          => $blog_post_one_query_paged,
						'order'   => $settings['query_order'],
						'posts_per_page' => $settings['post_count']['size']
					);

				endif;
				$blog_post_one_query = new \WP_Query($blog_post_one_query_args);
				?>
				<?php while ($blog_post_one_query->have_posts()) :
					$blog_post_one_query->the_post();

					$category = get_the_category();

				?>
					<!--Blog Two Single Start-->
					<div class="col-xl-4 col-lg-4 wow fadeInUp" data-wow-delay="100ms">
						<div class="blog-two__single">
							<div class="blog-two__img">
								<?php the_post_thumbnail('roofsie_blog_370X245'); ?>
							</div>
							<div class="blog-two__content-box">
								<div class="blog-two__content">
									<ul class="list-unstyled blog-two__meta ml-0">
										<li><?php roofsie_posted_on(); ?></li>
										<li><?php roofsie_posted_by(); ?></li>
									</ul>
									<h3 class="blog-two__title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
									<p class="blog-two__text"><?php echo wp_kses(roofsie_excerpt($settings['post_word_count']['size']), 'roofsie_allowed_tags'); ?></p>
								</div>
								<div class="blog-two__bottom">
									<div class="blog-two__comment">
										<p> <i class="far fa-comments"></i> <?php comments_number(); ?></p>
									</div>
									<div class="blog-two__read-more">
										<a href="<?php the_permalink(); ?>"><?php esc_html_e('Read More ', 'roofsie-addon'); ?><i class="fa fa-arrow-right"></i> </a>
									</div>
								</div>
							</div>
						</div>
					</div>
					<!--Blog Two Single End-->
				<?php endwhile; ?>
				<?php if ('yes' == $settings['pagination_status']) : ?>
					<div class="col-lg-12">
						<div class="blog-pagination portfolio-page__btn-box justify-content-center text-center">
							<?php roofsie_custom_query_pagination($blog_post_one_query_paged, $blog_post_one_query->max_num_pages); ?>
						</div><!-- /.blog-post-pagination -->
					</div><!-- /.col-lg-12 -->
				<?php endif; ?>
				<?php wp_reset_postdata(); ?>
			</div>
		</div>
	</section>
	<!--Blog Two End-->

<?php endif; ?>