<?php if ('layout_three' == $settings['layout_type']) : ?>
	<!--Blog One Start-->
	<section class="blog-one blog-three">
		<div class="blog-three__bg-box">
			<?php if (!empty($settings['bg_image']['url'])) : ?>
				<div class="blog-three__bg" style="background-image: url(<?php echo esc_url($settings['bg_image']['url']) ?>)"></div>
			<?php endif; ?>
		</div>
		<div class="container">
			<?php if (!empty($settings['sec_sub_title']) || !empty($settings['sec_title'])) : ?>
				<div class="section-title text-center">
					<?php if (!empty($settings['sec_sub_title'])) : ?>
						<div class="section-sub-title-box">
							<p class="section-sub-title"><?php echo wp_kses($settings['sec_sub_title'], 'roofsie_allowed_tags'); ?></p>
							<?php if (!empty($settings['sub_title_image']['url'])) : ?>
								<div class="section-title-shape-1">
									<img src="<?php echo esc_url($settings['sub_title_image']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['sub_title_image']['id'])); ?>">
								</div>
							<?php endif; ?>
						</div>
					<?php endif; ?>
					<?php if (!empty($settings['sec_title'])) : ?>
						<h2 class="section-title__title"><?php echo wp_kses($settings['sec_title'], 'roofsie_allowed_tags'); ?></h2>
					<?php endif; ?>
				</div>
			<?php endif; ?>
			<div class="row">
				<?php
				$blog_post_one_query_paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
				if (!empty($settings['select_category'])) :
					$blog_post_one_query_args = array(
						'post_type' => 'post',
						'post_status' => 'publish',
						'ignore_sticky_posts' => true,
						'orderby' => 'date',
						'order'   => $settings['query_order'],
						'posts_per_page' => $settings['post_count']['size'],
						'paged'          => $blog_post_one_query_paged,
						'tax_query' => array(
							array(
								'taxonomy' => 'category',
								'field' => 'slug',
								'terms' => $settings['select_category']
							)
						)
					);
				else :

					$blog_post_one_query_args = array(
						'post_type' => 'post',
						'post_status' => 'publish',
						'ignore_sticky_posts' => true,
						'orderby' => 'date',
						'paged'          => $blog_post_one_query_paged,
						'order'   => $settings['query_order'],
						'posts_per_page' => $settings['post_count']['size']
					);

				endif;
				$blog_post_one_query = new \WP_Query($blog_post_one_query_args);
				?>
				<?php while ($blog_post_one_query->have_posts()) :
					$blog_post_one_query->the_post();

					$category = get_the_category();

				?>
					<!--Blog One Single Start-->
					<div class="col-xl-4 col-lg-4 wow fadeInUp" data-wow-delay="100ms">
						<div class="blog-one__single">
							<div class="blog-one__img">
								<?php the_post_thumbnail('roofsie_blog_370X245'); ?>
							</div>
							<div class="blog-one__content">
								<div class="blog-one__user">
									<div class="blog-one__user-img">
										<?php echo get_avatar(get_the_author_meta('ID'), 50); ?>
									</div>
									<div class="blog-one__user-content">
										<p><?php echo esc_html__('by', 'roofsie-addon'); ?> <?php the_author(); ?></p>
										<h5> <?php the_time('F d, Y'); ?></h5>
									</div>
								</div>
								<h3 class="blog-one__title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
								<p class="blog-one__text"><?php echo wp_kses(roofsie_excerpt($settings['post_word_count']['size']), 'roofsie_allowed_tags'); ?></p>
								<div class="blog-one__read-more">
									<a href="<?php the_permalink(); ?>"><?php esc_html_e('Read More ', 'roofsie-addon'); ?> <i class="fa fa-arrow-right"></i></a>
								</div>
							</div>
						</div>
					</div>
					<!--Blog One Single End-->
				<?php endwhile; ?>
				<?php if ('yes' == $settings['pagination_status']) : ?>
					<div class="col-lg-12">
						<div class="blog-pagination portfolio-page__btn-box justify-content-center text-center">
							<?php roofsie_custom_query_pagination($blog_post_one_query_paged, $blog_post_one_query->max_num_pages); ?>
						</div><!-- /.blog-post-pagination -->
					</div><!-- /.col-lg-12 -->
				<?php endif; ?>
				<?php wp_reset_postdata(); ?>
			</div>
		</div>
	</section>
	<!--Blog One End-->

<?php endif; ?>