<?php if ('layout_four' == $settings['layout_type']) : ?>

	<!--Blog Page Start-->
	<section class="blog-page">
		<div class="container">
			<div class="row">
				<?php
				if (!empty($settings['select_category'])) :
					$blog_post_one_query_args = array(
						'post_type' => 'post',
						'post_status' => 'publish',
						'ignore_sticky_posts' => true,


						'orderby' => 'date',
						'order'   => $settings['query_order'],
						'posts_per_page' => $settings['post_count']['size'],
						'tax_query' => array(
							array(
								'taxonomy' => 'category',
								'field' => 'slug',
								'terms' => $settings['select_category']
							)
						)
					);
				else :

					$blog_post_one_query_args = array(
						'post_type' => 'post',
						'post_status' => 'publish',
						'ignore_sticky_posts' => true,
						'orderby' => 'date',
						'order'   => $settings['query_order'],
						'posts_per_page' => $settings['post_count']['size']
					);

				endif;
				$blog_post_one_query = new \WP_Query($blog_post_one_query_args);
				?>
				<?php while ($blog_post_one_query->have_posts()) :
					$blog_post_one_query->the_post();

				?>
					<!--Blog One Single Start-->
					<div class="col-xl-4 col-lg-4 col-md-6 wow fadeInUp" data-wow-delay="100ms">
						<div class="blog-one__single">
							<div class="blog-one__img">
								<?php the_post_thumbnail('roofsie_blog_370X245'); ?>
							</div>
							<div class="blog-one__content">
								<div class="blog-one__user">
									<div class="blog-one__user-img">
										<?php echo get_avatar(get_the_author_meta('ID'), 50); ?>
									</div>
									<div class="blog-one__user-content">
										<p><?php echo esc_html__('by', 'roofsie-addon'); ?> <?php the_author(); ?></p>
										<h5><?php the_time('F d, Y'); ?></h5>
									</div>
								</div>
								<h3 class="blog-one__title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
								<p class="blog-one__text"><?php echo wp_kses(roofsie_excerpt($settings['post_word_count']['size']), 'roofsie_allowed_tags'); ?></p>
								<div class="blog-one__read-more">
									<a href="<?php the_permalink(); ?>"><?php esc_html_e('Read More ', 'roofsie-addon'); ?> <i class="fa fa-arrow-right"></i></a>
								</div>
							</div>
						</div>
					</div>
					<!--Blog One Single End-->
				<?php endwhile; ?>
				<?php if ('yes' == $settings['pagination_status']) : ?>
					<div class="col-lg-12">
						<div class="blog-pagination portfolio-page__btn-box justify-content-center text-center">
							<?php roofsie_custom_query_pagination($blog_post_one_query_paged, $blog_post_one_query->max_num_pages); ?>
						</div><!-- /.blog-post-pagination -->
					</div><!-- /.col-lg-12 -->
				<?php endif; ?>
				<?php wp_reset_postdata(); ?>
			</div>
		</div>
	</section>
	<!--Blog Page End-->
<?php endif; ?>