<?php if ('layout_one' == $settings['layout_type']) : ?>
    <!--Awards Start-->
    <section class="awards">
        <div class="container">
            <?php if (!empty($settings['sec_title'])) : ?>
                <h4 class="awards__title"><?php echo wp_kses($settings['sec_title'], 'roofsie_allowed_tags'); ?></h4>
            <?php endif; ?>
            <div class="awards__carousel owl-carousel owl-theme thm-owl__carousel" data-owl-options='<?php echo esc_attr(roofsie_get_owl_options($settings)); ?>'>
                <?php foreach ($settings['award_images'] as $item) :  ?>
                    <!--Awards Single Start-->
                    <div class="item">
                        <div class="awards__single">
                            <div class="awards__img">
                                <img src="<?php echo esc_url($item['image']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($item['image']['id'])); ?>">
                            </div>
                        </div>
                    </div>
                    <!--Awards Single End-->
                <?php endforeach; ?>
            </div>
        </div>
    </section>
    <!--Awards End-->
<?php endif; ?>