<?php if ('layout_two' == $settings['layout_type']) : ?>
	<!--Why Choose One Start-->
	<section class="why-choose-one">
		<?php if (!empty($settings['layout_two_shape_one']['url'])) : ?>
			<div class="why-choose-one-bg" style="background-image: url(<?php echo esc_url($settings['layout_two_shape_one']['url']); ?>);"></div>
		<?php endif; ?>
		<div class="why-choose-one-shape-3 float-bob-y-2"></div>
		<?php if (!empty($settings['layout_two_shape_two']['url'])) : ?>
			<div class="why-choose-one-shape-4 float-bob-x">
				<img src="<?php echo esc_url($settings['layout_two_shape_two']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['layout_two_shape_two']['id'])); ?>">
			</div>
		<?php endif; ?>
		<div class="container">
			<div class="row">
				<div class="col-xl-6">
					<div class="why-choose-one__left">
						<?php if (!empty($settings['layout_two_sec_title']) || !empty($settings['layout_two_sec_sub_title'])) : ?>
							<div class="section-title text-left">
								<?php if (!empty($settings['layout_two_sec_sub_title'])) : ?>
									<div class="section-sub-title-box">
										<p class="section-sub-title"><?php echo wp_kses($settings['layout_two_sec_sub_title'], 'roofsie_allowed_tags'); ?></p>
										<?php if (!empty($settings['layout_two_sub_title_image']['url'])) : ?>
											<div class="section-title-shape-1">
												<img src="<?php echo esc_url($settings['layout_two_sub_title_image']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['layout_two_sub_title_image']['id'])); ?>">
											</div>
										<?php endif; ?>
									</div>
								<?php endif; ?>
								<?php if (!empty($settings['layout_two_sec_title'])) : ?>
									<h2 class="section-title__title"><?php echo wp_kses($settings['layout_two_sec_title'], 'roofsie_allowed_tags'); ?></h2>
								<?php endif; ?>
							</div>
						<?php endif; ?>
						<?php if (!empty($settings['layout_two_summary'])) : ?>
							<p class="why-choose-one__text"><?php echo wp_kses($settings['layout_two_summary'], 'roofsie_allowed_tags'); ?></p>
						<?php endif; ?>
						<?php if (!empty($settings['layout_two_feature_list'])) : ?>
							<div class="why-choose-one__points-box">
								<div class="row">
									<?php foreach ($settings['layout_two_feature_list'] as $item) : ?>
										<div class="col-xl-6 col-lg-6 col-md-6">
											<div class="why-choose-one__points-single">
												<div class="why-choose-one__points-icon">
													<?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
												</div>
												<div class="why-choose-one__points-title-box">
													<h4 class="why-choose-one__points-title"><?php echo wp_kses($item['title'], 'roofsie_allowed_tags'); ?></h4>
												</div>
											</div>
										</div>
									<?php endforeach; ?>
								</div>
							</div>
						<?php endif; ?>
					</div>
				</div>
				<div class="col-xl-6">
					<div class="why-choose-one__right">
						<div class="why-choose-one__img-box">
							<?php if (!empty($settings['layout_two_image']['url'])) : ?>
								<div class="why-choose-one__img wow slideInRight" data-wow-delay="100ms" data-wow-duration="2500ms">
									<img src="<?php echo esc_url($settings['layout_two_image']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['layout_two_image']['id'])); ?>">
								</div>
							<?php endif; ?>
							<div class="why-choose-one__shape-1"></div>
							<div class="why-choose-one__shape-2"></div>
							<?php if (!empty($settings['layout_two_name'])) : ?>
								<div class="why-choose-one__author-sign">
									<p><?php echo esc_html($settings['layout_two_name']); ?></p>
								</div>
							<?php endif; ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!--Why Choose One End-->
<?php endif; ?>