<?php if ('layout_three' == $settings['layout_type']) : ?>
	<!--About Two Start-->
	<section class="about-two">
		<div class="container">
			<div class="row">
				<div class="col-xl-6">
					<div class="about-two__left">
						<?php if (!empty($settings['layout_three_sec_title']) || !empty($settings['layout_three_sec_sub_title'])) : ?>
							<div class="section-title text-left">
								<?php if (!empty($settings['layout_three_sec_sub_title'])) : ?>
									<div class="section-sub-title-box">
										<p class="section-sub-title"><?php echo wp_kses($settings['layout_three_sec_sub_title'], 'roofsie_allowed_tags'); ?></p>
										<?php if (!empty($settings['layout_three_sub_title_image']['url'])) : ?>
											<div class="section-title-shape-1">
												<img src="<?php echo esc_url($settings['layout_three_sub_title_image']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['layout_three_sub_title_image']['id'])); ?>">
											</div>
										<?php endif; ?>
									</div>
								<?php endif; ?>
								<?php if (!empty($settings['layout_three_sec_title'])) : ?>
									<h2 class="section-title__title"><?php echo wp_kses($settings['layout_three_sec_title'], 'roofsie_allowed_tags'); ?></h2>
								<?php endif; ?>
							</div>
						<?php endif; ?>
						<?php if (!empty($settings['layout_three_highlighted_text'])) : ?>
							<p class="about-two__text-1"><?php echo wp_kses($settings['layout_three_highlighted_text'], 'roofsie_allowed_tags'); ?></p>
						<?php endif; ?>
						<?php if (!empty($settings['layout_three_summary'])) : ?>
							<p class="about-two__text-2"><?php echo wp_kses($settings['layout_three_summary'], 'roofsie_allowed_tags'); ?></p>
						<?php endif; ?>
						<?php if (is_array($settings['layout_three_feature_list'])) : ?>
							<ul class="list-unstyled about-two__points ml-0">
								<?php foreach ($settings['layout_three_feature_list']  as $item) : ?>
									<li>
										<div class="icon icon-svg">
											<?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
										</div>
										<div class="text">
											<h4><?php echo wp_kses($item['title'], 'roofsie_allowed_tags'); ?></h4>
											<p><?php echo wp_kses($item['content'], 'roofsie_allowed_tags'); ?></p>
										</div>
									</li>
								<?php endforeach; ?>
							</ul>
						<?php endif; ?>
						<?php if (!empty($settings['layout_three_button_label'])) : ?>
							<a <?php echo esc_attr(!empty($settings['layout_three_button_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($settings['layout_three_button_url']['url']); ?>" class="thm-btn about-two__btn"> <i class="fa fa-arrow-right"></i>
								<?php echo esc_html($settings['layout_three_button_label']); ?>
							</a>
						<?php endif; ?>
					</div>
				</div>
				<div class="col-xl-6">
					<div class="about-two__right">
						<div class="about-two__img-box wow slideInRight" data-wow-delay="100ms" data-wow-duration="2500ms">
							<?php if (!empty($settings['layout_three_image_one']['url'])) : ?>
								<div class="about-two__img">
									<img src="<?php echo esc_url($settings['layout_three_image_one']['url']) ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['layout_three_image_one']['id'])); ?>">
								</div>
							<?php endif; ?>
							<?php if (!empty($settings['layout_three_image_two']['url'])) : ?>
								<div class="about-two__img-two">
									<img src="<?php echo esc_url($settings['layout_three_image_two']['url']) ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['layout_three_image_two']['id'])); ?>">
								</div>
							<?php endif; ?>
							<?php if (!empty($settings['layout_three_image_shape']['url'])) : ?>
								<div class="about-two__line">
									<img src="<?php echo esc_url($settings['layout_three_image_shape']['url']) ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['layout_three_image_shape']['id'])); ?>">
								</div>
							<?php endif; ?>
							<div class="about-two__shape-1"></div>
							<div class="about-two__practice-year">
								<div class="about-two__practice-year-inner">
									<?php if (!empty($settings['layout_three_image_caption_image']['url'])) : ?>
										<div class="about-two__practice-year-shape">
											<img src="<?php echo esc_url($settings['layout_three_image_caption_image']['url']) ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['layout_three_image_caption_image']['id'])); ?>">
										</div>
									<?php endif; ?>
									<div class="about-two__practice-year-content">
										<h3><?php echo esc_html($settings['layout_three_caption_count']); ?></h3>
										<p><?php echo wp_kses($settings['layout_three_caption_text'], 'roofsie_allowed_tags'); ?></p>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!--About Two End-->
<?php endif; ?>