<?php if ('layout_six' == $settings['layout_type']) : ?>
	<!--FAQ One Start-->
	<section class="faq-one">
		<div class="container">
			<div class="row">
				<div class="col-xl-6 col-lg-6">
					<div class="faq-one__lef">
						<?php if (!empty($settings['layout_six_image']['url'])) : ?>
							<div class="faq-one__img">
								<img src="<?php echo esc_url($settings['layout_six_image']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['layout_six_image']['id'])); ?>">
							</div>
						<?php endif; ?>
						<?php if (is_array($settings['layout_features_list'])) : ?>
							<ul class="list-unstyled faq-one__point ml-0">
								<?php foreach ($settings['layout_features_list'] as $item) : ?>
									<li>
										<div class="icon">
											<?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
										</div>
										<div class="content">
											<h4><?php echo esc_html($item['title']); ?></h4>
											<p><?php echo esc_html($item['content']); ?></p>
										</div>
									</li>
								<?php endforeach; ?>
							</ul>
						<?php endif; ?>
					</div>
				</div>
				<div class="col-xl-6 col-lg-6">
					<div class="faq-one__right">
						<div class="accrodion-grp faq-one-accrodion" data-grp-name="faq-one-accrodion-<?php echo esc_attr(uniqid()); ?>">
							<?php
							foreach ($settings['layout_six_faq_lists'] as $list) :
							?>
								<div class="accrodion <?php echo esc_attr(('yes' == $list['active_status'] ? 'active' : '')); ?>">
									<div class="accrodion-title">
										<h4><?php echo wp_kses($list['question'], 'roofsie_allowed_tags'); ?></h4>
									</div>
									<div class="accrodion-content">
										<div class="inner">
											<p><?php echo wp_kses($list['answer'], 'roofsie_allowed_tags'); ?> </p>
										</div><!-- /.inner -->
									</div>
								</div>
							<?php
							endforeach; ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!--FAQ One End-->
<?php endif; ?>