<?php if ('layout_one' == $settings['layout_type']) : ?>

	<!--About One Start-->
	<section class="about-one">
		<?php if (!empty($settings['layout_one_section_bg']['url'])) : ?>
			<div class="about-one__shape float-bob-x">
				<img src="<?php echo esc_url($settings['layout_one_section_bg']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['layout_one_section_bg']['id'])); ?>">
			</div>
		<?php endif; ?>
		<div class="container">
			<div class="row">
				<div class="col-xl-6">
					<div class="about-one__left">
						<div class="about-one__img-box wow slideInLeft" data-wow-delay="100ms" data-wow-duration="2500ms">
							<?php if (!empty($settings['layout_one_image']['url'])) : ?>
								<div class="about-one__img">
									<img src="<?php echo esc_url($settings['layout_one_image']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['layout_one_image']['id'])); ?>">
								</div>
							<?php endif; ?>
							<?php if (!empty($settings['layout_one_image_bg']['url'])) : ?>
								<div class="about-one__line">
									<img src="<?php echo esc_url($settings['layout_one_image_bg']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['layout_one_image_bg']['id'])); ?>">
								</div>
							<?php endif; ?>
							<div class="about-one__satisfied">
								<div class="about-one__satisfied-inner">
									<?php if (!empty($settings['layout_one_caption_bg']['url'])) : ?>
										<div class="about-one__satisfied-shape">
											<img src="<?php echo esc_url($settings['layout_one_caption_bg']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['layout_one_caption_bg']['id'])); ?>">
										</div>
									<?php endif; ?>

									<div class="about-one__satisfied-content">
										<div class="about-one__satisfied-count-box">
											<h3 class="odometer" data-count="<?php echo esc_attr($settings['layout_one_image_count']); ?>">00</h3>
											<span class="about-one__satisfied-percent">%</span>
										</div>
										<p class="about-one__satisfied-text"><?php echo esc_html($settings['layout_one_image_caption_text']); ?></p>
									</div>

								</div>
							</div>
							<?php if (!empty($settings['big_text'])) : ?>
								<div class="about-one__big-text"><?php echo esc_html($settings['big_text']); ?></div>
							<?php endif; ?>
						</div>
					</div>
				</div>
				<div class="col-xl-6">
					<div class="about-one__right">
						<?php if (!empty($settings['layout_one_sec_title']) || !empty($settings['layout_one_sec_sub_title'])) : ?>
							<div class="section-title text-left">
								<?php if (!empty($settings['layout_one_sec_sub_title'])) : ?>
									<div class="section-sub-title-box">
										<p class="section-sub-title"><?php echo wp_kses($settings['layout_one_sec_sub_title'], 'roofsie_allowed_tags'); ?></p>
										<?php if (!empty($settings['layout_one_sub_title_image']['url'])) :  ?>
											<div class="section-title-shape-1">
												<img src="<?php echo esc_url($settings['layout_one_sub_title_image']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['layout_one_sub_title_image']['id'])); ?>">
											</div>
										<?php endif; ?>
									</div>
								<?php endif; ?>
								<?php if (!empty($settings['layout_one_sec_title'])) : ?>
									<h2 class="section-title__title"><?php echo wp_kses($settings['layout_one_sec_title'], 'roofsie_allowed_tags'); ?></h2>
								<?php endif; ?>
							</div>
						<?php endif; ?>
						<?php if (!empty($settings['layout_one_summary'])) : ?>
							<p class="about-one__text"><?php echo wp_kses($settings['layout_one_summary'], 'roofsie_allowed_tags'); ?></p>
						<?php endif; ?>
						<?php if (is_array($settings['layout_one_features'])) : ?>
							<ul class="list-unstyled about-one__points ml-0">
								<?php $i = 0;
								foreach ($settings['layout_one_features'] as $item) : ?>
									<li>
										<div class="icon-box">
											<div class="icon icon-svg">
												<?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
											</div>
											<div class="text-box">
												<p><?php echo esc_html($item['title']); ?></p>
											</div>
										</div>
										<div class="text-box-two">
											<p><?php echo esc_html($item['summary']); ?></p>
										</div>
									</li>
								<?php $i++;
								endforeach; ?>
							</ul>
						<?php endif; ?>
						<?php if (!empty($settings['layout_one_button_label'])) : ?>
							<a <?php echo esc_attr(!empty($settings['layout_one_button_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($settings['layout_one_button_url']['url']); ?>" class="thm-btn about-one__btn"> <i class="fa fa-arrow-right"></i><?php echo esc_html($settings['layout_one_button_label']); ?></a>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!--About One End-->
<?php endif; ?>