<?php if ('layout_four' == $settings['layout_type']) : ?>
	<!--Why Choose Two Start-->
	<section class="why-choose-two">
		<?php if (!empty($settings['layout_four_bg_image']['url'])) : ?>
			<div class="why-choose-two-bg" style="background-image: url(<?php echo esc_url($settings['layout_four_bg_image']['url']); ?>)"></div>
		<?php endif; ?>
		<div class="container">
			<?php if (!empty($settings['layout_four_sec_title']) || !empty($settings['layout_four_sec_sub_title'])) : ?>
				<div class="section-title text-center">
					<?php if (!empty($settings['layout_four_sec_sub_title'])) : ?>
						<div class="section-sub-title-box">

							<p class="section-sub-title"><?php echo wp_kses($settings['layout_four_sec_sub_title'], 'roofsie_allowed_tags'); ?></p>
							<?php if (!empty($settings['layout_four_sub_title_image']['url'])) : ?>
								<div class="section-title-shape-1">
									<img src="<?php echo esc_url($settings['layout_four_sub_title_image']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['layout_four_sub_title_image']['id'])); ?>">
								</div>
							<?php endif; ?>
						</div>
					<?php endif; ?>
					<?php if (!empty($settings['layout_four_sec_title'])) : ?>
						<h2 class="section-title__title"><?php echo wp_kses($settings['layout_four_sec_title'], 'roofsie_allowed_tags'); ?></h2>
					<?php endif; ?>
				</div>
			<?php endif; ?>
			<div class="row">
				<div class="col-xl-4">
					<div class="why-choose-two__left">
						<ul class="list-unstyled why-choose-two__list-one ml-0">
							<?php
							foreach ($settings['layout_four_Left_features'] as $item) : ?>
								<li>
									<div class="icon icon-svg-large">
										<?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
									</div>
									<div class="content">
										<h4><?php echo wp_kses($item['title'], 'roofsie_allowed_tags'); ?></h4>
										<p><?php echo wp_kses($item['summary'], 'roofsie_allowed_tags'); ?></p>
										<div class="why-choose-two__read-more">
											<a <?php echo esc_attr(!empty($item['button_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['button_url']['url']); ?>"><?php echo esc_html($item['button_label']); ?> <i class="fa fa-arrow-right"></i> </a>
										</div>
									</div>
								</li>
							<?php endforeach; ?>
						</ul>
					</div>
				</div>
				<div class="col-xl-4">
					<div class="why-choose-two__middle">
						<div class="why-choose-two__img-box">
							<div class="why-choose-two__img-one">
								<?php if (!empty($settings['layout_four_image']['url'])) : ?>
									<img src="<?php echo esc_url($settings['layout_four_image']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['layout_four_image']['id'])); ?>">
								<?php endif; ?>
								<?php if (!empty($settings['layout_four_image_shape']['url'])) : ?>
									<div class="why-choose-two__img-two">
										<img src="<?php echo esc_url($settings['layout_four_image_shape']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['layout_four_image_shape']['id'])); ?>">
									</div>
								<?php endif; ?>
							</div>
						</div>
					</div>
				</div>
				<div class="col-xl-4">
					<div class="why-choose-two__right">
						<ul class="list-unstyled why-choose-two__list-two clearfix ml-0">
							<?php
							foreach ($settings['layout_four_Right_features'] as $item) : ?>
								<li class="clearfix">
									<div class="content">
										<h4><?php echo wp_kses($item['title'], 'roofsie_allowed_tags'); ?></h4>
										<p><?php echo wp_kses($item['summary'], 'roofsie_allowed_tags'); ?></p>
										<div class="why-choose-two__read-more">
											<a <?php echo esc_attr(!empty($item['button_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['button_url']['url']); ?>"><?php echo esc_html($item['button_label']); ?> <i class="fa fa-arrow-right"></i> </a>
										</div>
									</div>
									<div class="icon">
										<?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
									</div>
								</li>
							<?php endforeach; ?>
						</ul>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!--Why Choose Two End-->
<?php endif; ?>