<?php if ('layout_five' == $settings['layout_type']) : ?>
	<!--About Three Start-->
	<section class="about-three">
		<?php if (!empty($settings['layout_five_shape_one']['url'])) : ?>
			<div class="about-three-shape-1 float-bob-x">
				<img src="<?php echo esc_url($settings['layout_five_shape_one']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['layout_five_shape_one']['id'])); ?>">
			</div>
		<?php endif; ?>
		<?php if (!empty($settings['layout_five_shape_two']['url'])) : ?>
			<div class="about-three-img-3 float-bob-x">
				<img src="<?php echo esc_url($settings['layout_five_shape_two']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['layout_five_shape_two']['id'])); ?>">
			</div>
		<?php endif; ?>
		<div class="container">
			<div class="row">
				<div class="col-xl-6">
					<div class="about-three__left">
						<div class="about-three__img-box wow slideInLeft" data-wow-delay="100ms" data-wow-duration="2500ms">
							<?php if (!empty($settings['layout_five_image_one']['url'])) : ?>
								<div class="about-three__img">
									<img src="<?php echo esc_url($settings['layout_five_image_one']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['layout_five_image_one']['id'])); ?>">
								</div>
							<?php endif; ?>
							<?php if (!empty($settings['layout_five_image_two']['url'])) : ?>
								<div class="about-three__img-two">
									<img src="<?php echo esc_url($settings['layout_five_image_two']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['layout_five_image_two']['id'])); ?>">
								</div>
							<?php endif; ?>
							<div class="about-three__border"></div>
						</div>
					</div>
				</div>
				<div class="col-xl-6">
					<div class="about-three__right">
						<?php if (!empty($settings['layout_five_sec_title']) || !empty($settings['layout_five_sec_sub_title'])) : ?>
							<div class="section-title text-left">
								<?php if (!empty($settings['layout_five_sec_sub_title'])) : ?>
									<div class="section-sub-title-box">
										<p class="section-sub-title"><?php echo wp_kses($settings['layout_five_sec_sub_title'], 'roofsie_allowed_tags'); ?></p>
										<?php if (!empty($settings['layout_five_sub_title_image']['url'])) : ?>
											<div class="section-title-shape-1">
												<img src="<?php echo esc_url($settings['layout_five_sub_title_image']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['layout_five_sub_title_image']['id'])); ?>">
											</div>
										<?php endif; ?>
									</div>
								<?php endif; ?>
								<?php if (!empty($settings['layout_five_sec_title'])) : ?>
									<h2 class="section-title__title"><?php echo wp_kses($settings['layout_five_sec_title'], 'roofsie_allowed_tags'); ?></h2>
								<?php endif; ?>
							</div>
						<?php endif; ?>
						<?php if (!empty($settings['layout_five_summary'])) : ?>
							<p class="about-three__text"><?php echo wp_kses($settings['layout_five_summary'], 'roofsie_allowed_tags'); ?></p>
						<?php endif; ?>
						<?php if (is_array($settings['layout_five_check_list'])) : ?>
							<ul class="list-unstyled about-three__point ml-0">
								<?php
								foreach ($settings['layout_five_check_list'] as $checklist) : ?>
									<li>
										<div class="icon icon-svg">
											<?php \Elementor\Icons_Manager::render_icon($checklist['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'i'); ?>
										</div>
										<div class="text">
											<p><?php echo esc_html($checklist['title']); ?></p>
										</div>
									</li>
								<?php
								endforeach; ?>
							</ul>
						<?php endif; ?>
						<?php if (!empty($settings['layout_five_button_label'])) : ?>
							<a <?php echo esc_attr(!empty($settings['layout_five_button_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($settings['layout_five_button_url']['url']); ?>" class="thm-btn about-three__btn"> <?php \Elementor\Icons_Manager::render_icon($settings['layout_five_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'i'); ?>
								<?php echo esc_html($settings['layout_five_button_label']); ?>
							</a>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!--About Three End-->
<?php endif; ?>